import { Header } from "@/components/Header";
import { Footer } from "@/components/Footer";
import { Button } from "@/components/ui/button";
import { Phone, MapPin, Mail, Clock, MessageCircle, Star } from "lucide-react";
import heroHotel from "@/assets/hero-hotel.jpg";

const reviews = [
  {
    name: "Chioma A.",
    rating: 4,
    date: "2 weeks ago",
    text: "Very clean rooms and friendly staff. The location is perfect for accessing Owerri. Will definitely come back!",
  },
  {
    name: "Emmanuel O.",
    rating: 5,
    date: "1 month ago",
    text: "Excellent service and comfortable beds. The constant power supply was a huge plus. Highly recommended!",
  },
  {
    name: "Blessing N.",
    rating: 3,
    date: "1 month ago",
    text: "Good value for money. The restaurant food was delicious. Room was clean and spacious.",
  },
];

const Contact = () => {
  return (
    <div className="min-h-screen">
      <Header />
      <main>
        {/* Hero Banner */}
        <section className="relative h-[40vh] min-h-[300px] flex items-center justify-center">
          <div
            className="absolute inset-0 bg-cover bg-center"
            style={{ backgroundImage: `url(${heroHotel})` }}
          >
            <div className="absolute inset-0 bg-emerald-dark/70" />
          </div>
          <div className="relative z-10 text-center px-4">
            <span className="text-gold font-medium tracking-widest uppercase text-sm">
              Get In Touch
            </span>
            <h1 className="font-serif text-4xl md:text-5xl lg:text-6xl font-bold text-primary-foreground mt-2">
              Contact Us
            </h1>
            <p className="text-primary-foreground/80 mt-4 max-w-xl mx-auto">
              We're here to help with your reservations and inquiries
            </p>
          </div>
        </section>

        {/* Contact Info & Map */}
        <section className="py-16 md:py-20 bg-background">
          <div className="container mx-auto px-4">
            <div className="grid lg:grid-cols-2 gap-12 max-w-6xl mx-auto">
              {/* Contact Details */}
              <div>
                <span className="text-gold font-medium tracking-widest uppercase text-sm">
                  Reach Us
                </span>
                <h2 className="font-serif text-3xl md:text-4xl font-bold text-foreground mt-2 mb-6">
                  Contact Information
                </h2>

                <div className="space-y-6">
                  <a
                    href="tel:07045064559"
                    className="flex items-start gap-4 p-4 bg-card rounded-xl hover:shadow-card transition-shadow group"
                  >
                    <div className="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center group-hover:bg-primary/20 transition-colors">
                      <Phone className="w-6 h-6 text-primary" />
                    </div>
                    <div>
                      <h3 className="font-semibold text-foreground">Phone</h3>
                      <p className="text-muted-foreground">0704 506 4559</p>
                      <p className="text-sm text-gold mt-1">Click to call</p>
                    </div>
                  </a>

                  <a
                    href="https://wa.me/2347045064559?text=Hello%20Graziella%20Hotels%2C%20I%20would%20like%20to%20make%20a%20reservation."
                    target="_blank"
                    rel="noopener noreferrer"
                    className="flex items-start gap-4 p-4 bg-card rounded-xl hover:shadow-card transition-shadow group"
                  >
                    <div className="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center group-hover:bg-green-200 transition-colors">
                      <MessageCircle className="w-6 h-6 text-green-600" />
                    </div>
                    <div>
                      <h3 className="font-semibold text-foreground">WhatsApp</h3>
                      <p className="text-muted-foreground">Send us a message</p>
                      <p className="text-sm text-green-600 mt-1">Chat with us</p>
                    </div>
                  </a>

                  <a
                    href="mailto:info@graziellahotels.com"
                    className="flex items-start gap-4 p-4 bg-card rounded-xl hover:shadow-card transition-shadow group"
                  >
                    <div className="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center group-hover:bg-primary/20 transition-colors">
                      <Mail className="w-6 h-6 text-primary" />
                    </div>
                    <div>
                      <h3 className="font-semibold text-foreground">Email</h3>
                      <p className="text-muted-foreground">info@graziellahotels.com</p>
                      <p className="text-sm text-gold mt-1">Send an email</p>
                    </div>
                  </a>

                  <div className="flex items-start gap-4 p-4 bg-card rounded-xl">
                    <div className="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center">
                      <MapPin className="w-6 h-6 text-primary" />
                    </div>
                    <div>
                      <h3 className="font-semibold text-foreground">Address</h3>
                      <p className="text-muted-foreground">
                        KLM 7, Owerri – Onitsha Road,<br />
                        Orogwe, Ogbaku, Imo State, Nigeria
                      </p>
                    </div>
                  </div>

                  <div className="flex items-start gap-4 p-4 bg-card rounded-xl">
                    <div className="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center">
                      <Clock className="w-6 h-6 text-primary" />
                    </div>
                    <div>
                      <h3 className="font-semibold text-foreground">Hours</h3>
                      <p className="text-muted-foreground">
                        Front Desk: 24 hours<br />
                        Check-in: 2:00 PM | Check-out: 12:00 PM
                      </p>
                    </div>
                  </div>
                </div>

                <div className="mt-8 flex flex-col sm:flex-row gap-4">
                  <a href="tel:07045064559" className="flex-1">
                    <Button size="lg" className="w-full gap-2">
                      <Phone className="w-5 h-5" />
                      Call Now
                    </Button>
                  </a>
                  <a
                    href="https://wa.me/2347045064559?text=Hello%20Graziella%20Hotels%2C%20I%20would%20like%20to%20make%20a%20reservation."
                    target="_blank"
                    rel="noopener noreferrer"
                    className="flex-1"
                  >
                    <Button size="lg" variant="outline" className="w-full gap-2 border-green-600 text-green-600 hover:bg-green-50">
                      <MessageCircle className="w-5 h-5" />
                      WhatsApp
                    </Button>
                  </a>
                </div>
              </div>

              {/* Map */}
              <div>
                <span className="text-gold font-medium tracking-widest uppercase text-sm">
                  Find Us
                </span>
                <h2 className="font-serif text-3xl md:text-4xl font-bold text-foreground mt-2 mb-6">
                  Our Location
                </h2>
                <div className="rounded-xl overflow-hidden shadow-elegant h-[400px] lg:h-[500px]">
                  <iframe
                    src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3972.123456789012!2d7.0123456789!3d5.456789012345!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zNcKwMjcnMjQuNCJOIDfCsDAwJzQ0LjQiRQ!5e0!3m2!1sen!2sng!4v1234567890123"
                    width="100%"
                    height="100%"
                    style={{ border: 0 }}
                    allowFullScreen
                    loading="lazy"
                    referrerPolicy="no-referrer-when-downgrade"
                    title="Graziella Hotels Location"
                  />
                </div>
                <p className="text-muted-foreground text-sm mt-4 text-center">
                  Located on the Owerri–Onitsha Road, easily accessible from Owerri city center
                </p>
              </div>
            </div>
          </div>
        </section>

        {/* Reviews Section */}
        <section className="py-16 bg-secondary">
          <div className="container mx-auto px-4">
            <div className="text-center max-w-2xl mx-auto mb-12">
              <span className="text-gold font-medium tracking-widest uppercase text-sm">
                Testimonials
              </span>
              <h2 className="font-serif text-3xl md:text-4xl font-bold text-foreground mt-2 mb-4">
                Guest Reviews
              </h2>
              <div className="flex items-center justify-center gap-2 mb-4">
                <div className="flex">
                  {[...Array(5)].map((_, i) => (
                    <Star
                      key={i}
                      className={`w-5 h-5 ${i < 3 ? "text-gold fill-gold" : i < 4 ? "text-gold fill-gold/50" : "text-muted-foreground"}`}
                    />
                  ))}
                </div>
                <span className="text-foreground font-semibold">3.3</span>
                <span className="text-muted-foreground">from 322 reviews</span>
              </div>
            </div>

            <div className="grid md:grid-cols-3 gap-6 max-w-5xl mx-auto">
              {reviews.map((review, index) => (
                <div key={index} className="bg-card p-6 rounded-xl shadow-card">
                  <div className="flex items-center gap-1 mb-3">
                    {[...Array(5)].map((_, i) => (
                      <Star
                        key={i}
                        className={`w-4 h-4 ${i < review.rating ? "text-gold fill-gold" : "text-muted-foreground"}`}
                      />
                    ))}
                  </div>
                  <p className="text-muted-foreground mb-4 text-sm leading-relaxed">
                    "{review.text}"
                  </p>
                  <div className="flex items-center justify-between">
                    <span className="font-semibold text-foreground">{review.name}</span>
                    <span className="text-xs text-muted-foreground">{review.date}</span>
                  </div>
                </div>
              ))}
            </div>
          </div>
        </section>

        {/* CTA */}
        <section className="py-16 bg-primary">
          <div className="container mx-auto px-4 text-center">
            <h2 className="font-serif text-3xl md:text-4xl font-bold text-primary-foreground mb-4">
              Ready to Book Your Stay?
            </h2>
            <p className="text-primary-foreground/80 mb-8 max-w-xl mx-auto">
              Contact us today and let us make your stay memorable.
            </p>
            <a href="tel:07045064559">
              <Button size="lg" variant="secondary" className="gap-2">
                <Phone className="w-5 h-5" />
                Call to Reserve
              </Button>
            </a>
          </div>
        </section>
      </main>
      <Footer />
    </div>
  );
};

export default Contact;
