import { Header } from "@/components/Header";
import { Footer } from "@/components/Footer";
import { Button } from "@/components/ui/button";
import { 
  Phone,
  Wifi, 
  Car, 
  Utensils, 
  Shield, 
  Clock, 
  Zap, 
  Sparkles, 
  ConciergeBell,
  AirVent,
  Tv,
  Coffee,
  Droplets,
  Users,
  Briefcase
} from "lucide-react";
import heroHotel from "@/assets/hero-hotel.jpg";
import galleryRestaurant from "@/assets/gallery-restaurant.jpg";
import galleryReception from "@/assets/gallery-reception.jpg";

const mainAmenities = [
  {
    icon: Wifi,
    title: "Free High-Speed WiFi",
    description: "Stay connected with complimentary high-speed internet throughout the hotel. Perfect for business travelers and families alike.",
  },
  {
    icon: Car,
    title: "Secure Parking",
    description: "Spacious and secure parking facility with 24-hour security surveillance. Free for all hotel guests.",
  },
  {
    icon: Utensils,
    title: "Restaurant & Bar",
    description: "Enjoy delicious local and continental cuisine at our in-house restaurant. Fresh ingredients prepared by experienced chefs.",
  },
  {
    icon: Shield,
    title: "24/7 Security",
    description: "Round-the-clock security personnel and comprehensive CCTV surveillance ensure your safety and peace of mind.",
  },
  {
    icon: Clock,
    title: "24-Hour Front Desk",
    description: "Our friendly and professional staff is available around the clock to assist with any request or inquiry.",
  },
  {
    icon: Zap,
    title: "Constant Power Supply",
    description: "Uninterrupted electricity with industrial backup generators always on standby. Never experience power outages.",
  },
];

const roomAmenities = [
  { icon: AirVent, title: "Air Conditioning", description: "Climate-controlled rooms for comfort in any weather" },
  { icon: Tv, title: "Flat Screen TV", description: "Modern TVs with cable channels in all rooms" },
  { icon: Droplets, title: "Hot Water", description: "24-hour hot water supply in all bathrooms" },
  { icon: Sparkles, title: "Daily Housekeeping", description: "Fresh linens and thorough cleaning daily" },
  { icon: ConciergeBell, title: "Room Service", description: "Food and beverages delivered to your room" },
  { icon: Coffee, title: "Tea/Coffee Making", description: "Complimentary tea and coffee facilities" },
];

const businessAmenities = [
  { icon: Briefcase, title: "Business Center", description: "Printing, copying, and fax services available" },
  { icon: Users, title: "Meeting Space", description: "Conference facilities for business meetings" },
];

const Amenities = () => {
  return (
    <div className="min-h-screen">
      <Header />
      <main>
        {/* Hero Banner */}
        <section className="relative h-[40vh] min-h-[300px] flex items-center justify-center">
          <div
            className="absolute inset-0 bg-cover bg-center"
            style={{ backgroundImage: `url(${heroHotel})` }}
          >
            <div className="absolute inset-0 bg-emerald-dark/70" />
          </div>
          <div className="relative z-10 text-center px-4">
            <span className="text-gold font-medium tracking-widest uppercase text-sm">
              Facilities
            </span>
            <h1 className="font-serif text-4xl md:text-5xl lg:text-6xl font-bold text-primary-foreground mt-2">
              Hotel Amenities
            </h1>
            <p className="text-primary-foreground/80 mt-4 max-w-xl mx-auto">
              Everything you need for a comfortable and enjoyable stay
            </p>
          </div>
        </section>

        {/* Main Amenities */}
        <section className="py-16 md:py-20 bg-background">
          <div className="container mx-auto px-4">
            <div className="text-center max-w-2xl mx-auto mb-12">
              <span className="text-gold font-medium tracking-widest uppercase text-sm">
                Hotel Features
              </span>
              <h2 className="font-serif text-3xl md:text-4xl font-bold text-foreground mt-2 mb-4">
                Main Facilities
              </h2>
              <p className="text-muted-foreground">
                Premium amenities designed for your comfort and convenience.
              </p>
            </div>

            <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8 max-w-6xl mx-auto">
              {mainAmenities.map((amenity) => (
                <div
                  key={amenity.title}
                  className="bg-card rounded-xl p-6 shadow-card hover:shadow-elegant transition-shadow duration-300"
                >
                  <div className="w-14 h-14 mb-4 bg-primary/10 rounded-xl flex items-center justify-center">
                    <amenity.icon className="w-7 h-7 text-primary" />
                  </div>
                  <h3 className="font-semibold text-lg text-foreground mb-2">
                    {amenity.title}
                  </h3>
                  <p className="text-muted-foreground text-sm leading-relaxed">
                    {amenity.description}
                  </p>
                </div>
              ))}
            </div>
          </div>
        </section>

        {/* Restaurant Section */}
        <section className="py-16 bg-secondary">
          <div className="container mx-auto px-4">
            <div className="grid lg:grid-cols-2 gap-12 items-center max-w-6xl mx-auto">
              <div>
                <img
                  src={galleryRestaurant}
                  alt="Graziella Restaurant"
                  className="rounded-2xl shadow-elegant w-full"
                />
              </div>
              <div>
                <span className="text-gold font-medium tracking-widest uppercase text-sm">
                  Dining
                </span>
                <h2 className="font-serif text-3xl md:text-4xl font-bold text-foreground mt-2 mb-4">
                  Restaurant & Bar
                </h2>
                <p className="text-muted-foreground mb-6 leading-relaxed">
                  Our in-house restaurant serves a delightful selection of Nigerian and continental 
                  dishes prepared by our experienced culinary team. From hearty breakfast to 
                  satisfying dinner, we cater to all tastes and preferences.
                </p>
                <ul className="space-y-3 mb-6">
                  <li className="flex items-center gap-3 text-muted-foreground">
                    <span className="w-2 h-2 bg-gold rounded-full" />
                    Breakfast: 7:00 AM - 10:30 AM
                  </li>
                  <li className="flex items-center gap-3 text-muted-foreground">
                    <span className="w-2 h-2 bg-gold rounded-full" />
                    Lunch: 12:00 PM - 3:00 PM
                  </li>
                  <li className="flex items-center gap-3 text-muted-foreground">
                    <span className="w-2 h-2 bg-gold rounded-full" />
                    Dinner: 6:00 PM - 10:00 PM
                  </li>
                  <li className="flex items-center gap-3 text-muted-foreground">
                    <span className="w-2 h-2 bg-gold rounded-full" />
                    Room service available 24/7
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </section>

        {/* Room Amenities */}
        <section className="py-16 bg-background">
          <div className="container mx-auto px-4">
            <div className="text-center max-w-2xl mx-auto mb-12">
              <span className="text-gold font-medium tracking-widest uppercase text-sm">
                In-Room
              </span>
              <h2 className="font-serif text-3xl md:text-4xl font-bold text-foreground mt-2 mb-4">
                Room Amenities
              </h2>
              <p className="text-muted-foreground">
                Every room comes equipped with modern amenities for your comfort.
              </p>
            </div>

            <div className="grid sm:grid-cols-2 lg:grid-cols-3 gap-6 max-w-4xl mx-auto">
              {roomAmenities.map((amenity) => (
                <div
                  key={amenity.title}
                  className="flex items-start gap-4 p-4 bg-card rounded-lg"
                >
                  <div className="w-10 h-10 flex-shrink-0 bg-gold/20 rounded-lg flex items-center justify-center">
                    <amenity.icon className="w-5 h-5 text-gold" />
                  </div>
                  <div>
                    <h3 className="font-semibold text-foreground mb-1">{amenity.title}</h3>
                    <p className="text-muted-foreground text-sm">{amenity.description}</p>
                  </div>
                </div>
              ))}
            </div>
          </div>
        </section>

        {/* Business Amenities */}
        <section className="py-16 bg-card">
          <div className="container mx-auto px-4">
            <div className="grid lg:grid-cols-2 gap-12 items-center max-w-6xl mx-auto">
              <div className="order-2 lg:order-1">
                <span className="text-gold font-medium tracking-widest uppercase text-sm">
                  For Business
                </span>
                <h2 className="font-serif text-3xl md:text-4xl font-bold text-foreground mt-2 mb-4">
                  Business Services
                </h2>
                <p className="text-muted-foreground mb-6 leading-relaxed">
                  Graziella Hotels & Suites caters to business travelers with dedicated facilities 
                  and services to help you stay productive during your stay.
                </p>
                <div className="space-y-4">
                  {businessAmenities.map((amenity) => (
                    <div key={amenity.title} className="flex items-start gap-4">
                      <div className="w-10 h-10 flex-shrink-0 bg-primary/10 rounded-lg flex items-center justify-center">
                        <amenity.icon className="w-5 h-5 text-primary" />
                      </div>
                      <div>
                        <h3 className="font-semibold text-foreground mb-1">{amenity.title}</h3>
                        <p className="text-muted-foreground text-sm">{amenity.description}</p>
                      </div>
                    </div>
                  ))}
                </div>
              </div>
              <div className="order-1 lg:order-2">
                <img
                  src={galleryReception}
                  alt="Graziella Reception"
                  className="rounded-2xl shadow-elegant w-full"
                />
              </div>
            </div>
          </div>
        </section>

        {/* CTA */}
        <section className="py-16 bg-primary">
          <div className="container mx-auto px-4 text-center">
            <h2 className="font-serif text-3xl md:text-4xl font-bold text-primary-foreground mb-4">
              Experience Our Amenities
            </h2>
            <p className="text-primary-foreground/80 mb-8 max-w-xl mx-auto">
              Book your stay today and enjoy all our premium facilities.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <a href="tel:07045064559">
                <Button size="lg" variant="secondary" className="gap-2">
                  <Phone className="w-5 h-5" />
                  Book Now
                </Button>
              </a>
              <a href="/rooms">
                <Button size="lg" variant="heroOutline">
                  View Rooms
                </Button>
              </a>
            </div>
          </div>
        </section>
      </main>
      <Footer />
    </div>
  );
};

export default Amenities;
