import { Header } from "@/components/Header";
import { Footer } from "@/components/Footer";
import { Button } from "@/components/ui/button";
import { Phone, Clock, Users, Heart, Shield } from "lucide-react";
import heroHotel from "@/assets/hero-hotel.jpg";
import galleryReception from "@/assets/gallery-reception.jpg";

const About = () => {
  return (
    <div className="min-h-screen">
      <Header />
      <main>
        {/* Hero Banner */}
        <section className="relative h-[40vh] min-h-[300px] flex items-center justify-center">
          <div
            className="absolute inset-0 bg-cover bg-center"
            style={{ backgroundImage: `url(${heroHotel})` }}
          >
            <div className="absolute inset-0 bg-emerald-dark/70" />
          </div>
          <div className="relative z-10 text-center px-4">
            <span className="text-gold font-medium tracking-widest uppercase text-sm">
              Our Story
            </span>
            <h1 className="font-serif text-4xl md:text-5xl lg:text-6xl font-bold text-primary-foreground mt-2">
              About Us
            </h1>
          </div>
        </section>

        {/* Main Content */}
        <section className="py-16 md:py-20 bg-background">
          <div className="container mx-auto px-4">
            <div className="grid lg:grid-cols-2 gap-12 items-center max-w-6xl mx-auto">
              <div>
                <span className="text-gold font-medium tracking-widest uppercase text-sm">
                  Welcome to Graziella
                </span>
                <h2 className="font-serif text-3xl md:text-4xl font-bold text-foreground mt-2 mb-6">
                  Your Home Away From Home
                </h2>
                <div className="space-y-4 text-muted-foreground leading-relaxed">
                  <p>
                    Nestled along the scenic Owerri–Onitsha Road in Ogbaku, Imo State, 
                    Graziella Hotels & Suites stands as a beacon of comfort and hospitality 
                    in the heart of Nigeria's Southeast.
                  </p>
                  <p>
                    Founded with a vision to provide affordable luxury to travelers, families, 
                    and business guests alike, we have built our reputation on the pillars of 
                    exceptional service, pristine accommodations, and genuine Nigerian hospitality.
                  </p>
                  <p>
                    Whether you're visiting for business, leisure, or a special occasion, our 
                    dedicated team ensures your stay is nothing short of memorable. From our 
                    well-appointed rooms to our attentive staff, every detail is crafted with 
                    your comfort in mind.
                  </p>
                </div>
                <div className="mt-8 p-4 bg-gold/10 rounded-lg border border-gold/20">
                  <div className="flex items-center gap-3">
                    <Clock className="w-6 h-6 text-gold" />
                    <div>
                      <p className="font-semibold text-foreground">Check-out Time</p>
                      <p className="text-muted-foreground">12:00 Noon</p>
                    </div>
                  </div>
                </div>
              </div>
              <div className="relative">
                <img
                  src={galleryReception}
                  alt="Graziella Hotels Reception"
                  className="rounded-2xl shadow-elegant w-full"
                />
                <div className="absolute -bottom-6 -left-6 bg-primary text-primary-foreground p-6 rounded-xl shadow-lg hidden md:block">
                  <p className="text-3xl font-bold text-gold">10+</p>
                  <p className="text-sm">Years of Excellence</p>
                </div>
              </div>
            </div>
          </div>
        </section>

        {/* Values */}
        <section className="py-16 bg-secondary">
          <div className="container mx-auto px-4">
            <div className="text-center max-w-2xl mx-auto mb-12">
              <h2 className="font-serif text-3xl md:text-4xl font-bold text-foreground mb-4">
                Our Core Values
              </h2>
              <p className="text-muted-foreground">
                What sets Graziella Hotels & Suites apart from the rest.
              </p>
            </div>
            <div className="grid md:grid-cols-3 gap-8 max-w-4xl mx-auto">
              <div className="text-center p-6">
                <div className="w-16 h-16 mx-auto mb-4 bg-gold/20 rounded-full flex items-center justify-center">
                  <Heart className="w-8 h-8 text-gold" />
                </div>
                <h3 className="font-semibold text-lg text-foreground mb-2">Warm Hospitality</h3>
                <p className="text-muted-foreground text-sm">
                  We treat every guest like family, ensuring you feel welcomed and valued throughout your stay.
                </p>
              </div>
              <div className="text-center p-6">
                <div className="w-16 h-16 mx-auto mb-4 bg-gold/20 rounded-full flex items-center justify-center">
                  <Shield className="w-8 h-8 text-gold" />
                </div>
                <h3 className="font-semibold text-lg text-foreground mb-2">Safety & Security</h3>
                <p className="text-muted-foreground text-sm">
                  Your safety is our priority with 24/7 security, CCTV surveillance, and secure parking.
                </p>
              </div>
              <div className="text-center p-6">
                <div className="w-16 h-16 mx-auto mb-4 bg-gold/20 rounded-full flex items-center justify-center">
                  <Users className="w-8 h-8 text-gold" />
                </div>
                <h3 className="font-semibold text-lg text-foreground mb-2">Guest Satisfaction</h3>
                <p className="text-muted-foreground text-sm">
                  We go above and beyond to exceed expectations and create lasting memories.
                </p>
              </div>
            </div>
          </div>
        </section>

        {/* CTA */}
        <section className="py-16 bg-primary">
          <div className="container mx-auto px-4 text-center">
            <h2 className="font-serif text-3xl md:text-4xl font-bold text-primary-foreground mb-4">
              Ready to Experience Graziella?
            </h2>
            <p className="text-primary-foreground/80 mb-8 max-w-xl mx-auto">
              Book your stay today and discover why guests keep coming back to Graziella Hotels & Suites.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <a href="tel:07045064559">
                <Button size="lg" variant="secondary" className="gap-2">
                  <Phone className="w-5 h-5" />
                  Call to Book
                </Button>
              </a>
              <a href="/rooms">
                <Button size="lg" variant="heroOutline">
                  View Our Rooms
                </Button>
              </a>
            </div>
          </div>
        </section>
      </main>
      <Footer />
    </div>
  );
};

export default About;
