import { Button } from "@/components/ui/button";
import { Check, Users, Bed, Bath } from "lucide-react";
import roomStandard from "@/assets/room-standard.jpg";
import roomDeluxe from "@/assets/room-deluxe.jpg";
import roomPremium from "@/assets/room-premium.jpg";

const rooms = [
  {
    name: "Standard Room",
    price: "₦12,000",
    image: roomStandard,
    description: "Comfortable and cozy room perfect for solo travelers or couples.",
    features: ["Queen Size Bed", "Air Conditioning", "Free WiFi", "TV", "Private Bathroom"],
    capacity: "2 Guests",
    beds: "1 Queen Bed",
    bath: "1 Bathroom",
    freeCancellation: true,
  },
  {
    name: "Deluxe Room",
    price: "₦18,000",
    image: roomDeluxe,
    description: "Spacious room with premium amenities for an elevated experience.",
    features: ["King Size Bed", "Air Conditioning", "Free WiFi", "Smart TV", "Mini Fridge", "Work Desk"],
    capacity: "2 Guests",
    beds: "1 King Bed",
    bath: "1 Bathroom",
    freeCancellation: true,
  },
  {
    name: "Premium Suite",
    price: "₦25,000",
    image: roomPremium,
    description: "Luxurious suite with separate living area for families and extended stays.",
    features: ["King Size Bed", "Living Area", "Air Conditioning", "Free WiFi", "Smart TV", "Mini Fridge", "Kitchenette"],
    capacity: "4 Guests",
    beds: "1 King Bed + Sofa",
    bath: "1 Bathroom",
    freeCancellation: true,
  },
];

export const RoomsSection = () => {
  const handleBookClick = () => {
    const element = document.querySelector("#contact");
    element?.scrollIntoView({ behavior: "smooth" });
  };

  return (
    <section id="rooms" className="py-20 bg-background">
      <div className="container mx-auto px-4">
        <div className="text-center max-w-2xl mx-auto mb-12">
          <span className="text-gold font-medium tracking-widest uppercase text-sm">
            Accommodations
          </span>
          <h2 className="font-serif text-3xl md:text-4xl lg:text-5xl font-bold text-foreground mt-2 mb-4">
            Our Rooms & Suites
          </h2>
          <p className="text-muted-foreground text-lg">
            Choose from our selection of well-appointed rooms designed for your comfort and relaxation.
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8 max-w-6xl mx-auto">
          {rooms.map((room, index) => (
            <div
              key={room.name}
              className="bg-card rounded-2xl overflow-hidden shadow-card hover:shadow-elegant transition-all duration-300 group"
              style={{ animationDelay: `${index * 100}ms` }}
            >
              {/* Image */}
              <div className="relative h-56 overflow-hidden">
                <img
                  src={room.image}
                  alt={room.name}
                  className="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500"
                />
                {room.freeCancellation && (
                  <div className="absolute top-4 left-4 bg-primary text-primary-foreground text-xs font-medium px-3 py-1 rounded-full">
                    Free Cancellation
                  </div>
                )}
              </div>

              {/* Content */}
              <div className="p-6">
                <div className="flex items-start justify-between mb-3">
                  <h3 className="font-serif text-xl font-semibold text-foreground">
                    {room.name}
                  </h3>
                  <div className="text-right">
                    <p className="text-2xl font-bold text-gold">{room.price}</p>
                    <span className="text-xs text-muted-foreground">/night</span>
                  </div>
                </div>

                <p className="text-muted-foreground text-sm mb-4">{room.description}</p>

                {/* Room Info */}
                <div className="flex items-center gap-4 mb-4 text-sm text-muted-foreground">
                  <div className="flex items-center gap-1">
                    <Users className="w-4 h-4" />
                    <span>{room.capacity}</span>
                  </div>
                  <div className="flex items-center gap-1">
                    <Bed className="w-4 h-4" />
                    <span>{room.beds}</span>
                  </div>
                  <div className="flex items-center gap-1">
                    <Bath className="w-4 h-4" />
                    <span>{room.bath}</span>
                  </div>
                </div>

                {/* Features */}
                <div className="border-t border-border pt-4 mb-4">
                  <div className="grid grid-cols-2 gap-2">
                    {room.features.slice(0, 4).map((feature) => (
                      <div key={feature} className="flex items-center gap-2 text-sm text-muted-foreground">
                        <Check className="w-4 h-4 text-primary flex-shrink-0" />
                        <span>{feature}</span>
                      </div>
                    ))}
                  </div>
                </div>

                <Button className="w-full" onClick={handleBookClick}>
                  Book Now
                </Button>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};
