import { Star, Quote } from "lucide-react";

const reviews = [
  {
    name: "Chinedu O.",
    rating: 4,
    date: "2 weeks ago",
    text: "Great value for money! The rooms are clean and spacious. Staff were very friendly and helpful. Would definitely recommend for business trips.",
  },
  {
    name: "Amaka E.",
    rating: 4,
    date: "1 month ago",
    text: "Nice and quiet hotel. Perfect for a family getaway. The restaurant serves delicious Nigerian dishes. Will come again!",
  },
  {
    name: "Emmanuel N.",
    rating: 3,
    date: "3 weeks ago",
    text: "Decent hotel for the price. Good location along the Owerri-Onitsha road. Room was comfortable and clean.",
  },
  {
    name: "Blessing I.",
    rating: 4,
    date: "2 months ago",
    text: "Stayed here for a conference. Excellent service from the front desk. The WiFi was fast and reliable. Highly recommended!",
  },
];

export const ReviewsSection = () => {
  const overallRating = 3.3;
  const totalReviews = 322;

  return (
    <section id="reviews" className="py-20 bg-background">
      <div className="container mx-auto px-4">
        <div className="max-w-6xl mx-auto">
          {/* Header with overall rating */}
          <div className="flex flex-col lg:flex-row lg:items-end lg:justify-between mb-12">
            <div>
              <span className="text-gold font-medium tracking-widest uppercase text-sm">
                Testimonials
              </span>
              <h2 className="font-serif text-3xl md:text-4xl lg:text-5xl font-bold text-foreground mt-2">
                Guest Reviews
              </h2>
            </div>
            
            {/* Rating Summary Card */}
            <div className="mt-6 lg:mt-0 bg-card p-6 rounded-2xl shadow-card flex items-center gap-6">
              <div className="text-center">
                <p className="text-5xl font-bold text-foreground">{overallRating}</p>
                <div className="flex items-center gap-1 mt-2">
                  {[...Array(5)].map((_, i) => (
                    <Star
                      key={i}
                      className={`w-5 h-5 ${
                        i < Math.floor(overallRating)
                          ? "fill-gold text-gold"
                          : i < overallRating
                          ? "fill-gold/50 text-gold"
                          : "text-muted"
                      }`}
                    />
                  ))}
                </div>
              </div>
              <div className="border-l border-border pl-6">
                <p className="text-muted-foreground text-sm">Based on</p>
                <p className="text-2xl font-semibold text-foreground">{totalReviews}</p>
                <p className="text-muted-foreground text-sm">reviews</p>
              </div>
            </div>
          </div>

          {/* Review Cards */}
          <div className="grid md:grid-cols-2 gap-6">
            {reviews.map((review, index) => (
              <div
                key={index}
                className="bg-card p-6 rounded-2xl shadow-card hover:shadow-elegant transition-all duration-300"
              >
                <div className="flex items-start justify-between mb-4">
                  <div className="flex items-center gap-3">
                    <div className="w-12 h-12 bg-primary rounded-full flex items-center justify-center">
                      <span className="text-primary-foreground font-semibold text-lg">
                        {review.name.charAt(0)}
                      </span>
                    </div>
                    <div>
                      <p className="font-semibold text-foreground">{review.name}</p>
                      <p className="text-muted-foreground text-sm">{review.date}</p>
                    </div>
                  </div>
                  <div className="flex items-center gap-1">
                    {[...Array(5)].map((_, i) => (
                      <Star
                        key={i}
                        className={`w-4 h-4 ${
                          i < review.rating
                            ? "fill-gold text-gold"
                            : "text-muted"
                        }`}
                      />
                    ))}
                  </div>
                </div>
                <div className="relative">
                  <Quote className="absolute -top-2 -left-1 w-8 h-8 text-gold/20" />
                  <p className="text-muted-foreground leading-relaxed pl-6">
                    {review.text}
                  </p>
                </div>
              </div>
            ))}
          </div>
        </div>
      </div>
    </section>
  );
};
