import { Button } from "@/components/ui/button";
import { Star, MapPin } from "lucide-react";
import heroImage from "@/assets/hero-hotel.jpg";

export const HeroSection = () => {
  const handleBookClick = () => {
    const element = document.querySelector("#contact");
    element?.scrollIntoView({ behavior: "smooth" });
  };

  return (
    <section
      id="home"
      className="relative min-h-screen flex items-center justify-center overflow-hidden"
    >
      {/* Background Image */}
      <div className="absolute inset-0">
        <img
          src={heroImage}
          alt="Graziella Hotels & Suites exterior"
          className="w-full h-full object-cover"
        />
        <div className="absolute inset-0 bg-gradient-to-b from-emerald-dark/70 via-emerald-dark/50 to-emerald-dark/80" />
      </div>

      {/* Content */}
      <div className="relative z-10 container mx-auto px-4 text-center">
        <div className="max-w-4xl mx-auto animate-fade-in">
          {/* Rating Badge */}
          <div className="inline-flex items-center gap-2 bg-card/20 backdrop-blur-sm px-4 py-2 rounded-full mb-6">
            <div className="flex items-center gap-1">
              {[...Array(3)].map((_, i) => (
                <Star key={i} className="w-4 h-4 fill-gold text-gold" />
              ))}
              <Star className="w-4 h-4 fill-gold/30 text-gold" />
              <Star className="w-4 h-4 text-gold/50" />
            </div>
            <span className="text-primary-foreground text-sm font-medium">
              3.3 from 322 reviews
            </span>
          </div>

          {/* Main Title */}
          <h1 className="font-serif text-4xl md:text-6xl lg:text-7xl font-bold text-primary-foreground mb-4 leading-tight">
            Graziella
            <span className="block text-gold">Hotels & Suites</span>
          </h1>

          {/* Tagline */}
          <p className="text-lg md:text-xl text-primary-foreground/90 mb-4 max-w-2xl mx-auto">
            Experience comfort and elegance at an affordable price. Your perfect home away from home in Imo State.
          </p>

          {/* Location */}
          <div className="flex items-center justify-center gap-2 text-primary-foreground/80 mb-6">
            <MapPin className="w-4 h-4" />
            <span className="text-sm">KLM 7, Owerri – Onitsha Road, Ogbaku, Imo State</span>
          </div>

          {/* Price */}
          <div className="mb-8">
            <span className="text-primary-foreground/70 text-sm">Starting from</span>
            <p className="text-3xl md:text-4xl font-serif font-bold text-gold">
              ₦12,000
              <span className="text-lg font-normal text-primary-foreground/80">/night</span>
            </p>
          </div>

          {/* CTA Buttons */}
          <div className="flex flex-col sm:flex-row items-center justify-center gap-4">
            <Button variant="hero" size="xl" onClick={handleBookClick}>
              Check Availability
            </Button>
            <a href="tel:07045064559">
              <Button variant="heroOutline" size="xl">
                Call Us Now
              </Button>
            </a>
          </div>
        </div>
      </div>

      {/* Scroll Indicator */}
      <div className="absolute bottom-8 left-1/2 -translate-x-1/2 animate-bounce">
        <div className="w-6 h-10 border-2 border-primary-foreground/50 rounded-full flex justify-center pt-2">
          <div className="w-1.5 h-3 bg-primary-foreground/70 rounded-full" />
        </div>
      </div>
    </section>
  );
};
