import { useState } from "react";
import { X } from "lucide-react";
import heroHotel from "@/assets/hero-hotel.jpg";
import roomStandard from "@/assets/room-standard.jpg";
import roomDeluxe from "@/assets/room-deluxe.jpg";
import roomPremium from "@/assets/room-premium.jpg";
import galleryReception from "@/assets/gallery-reception.jpg";
import galleryRestaurant from "@/assets/gallery-restaurant.jpg";

const galleryImages = [
  { src: heroHotel, alt: "Hotel Exterior", category: "Exterior" },
  { src: galleryReception, alt: "Hotel Reception", category: "Lobby" },
  { src: roomStandard, alt: "Standard Room", category: "Rooms" },
  { src: roomDeluxe, alt: "Deluxe Room", category: "Rooms" },
  { src: roomPremium, alt: "Premium Suite", category: "Suites" },
  { src: galleryRestaurant, alt: "Restaurant", category: "Dining" },
];

export const GallerySection = () => {
  const [selectedImage, setSelectedImage] = useState<string | null>(null);

  return (
    <section id="gallery" className="py-20 bg-card">
      <div className="container mx-auto px-4">
        <div className="text-center max-w-2xl mx-auto mb-12">
          <span className="text-gold font-medium tracking-widest uppercase text-sm">
            Gallery
          </span>
          <h2 className="font-serif text-3xl md:text-4xl lg:text-5xl font-bold text-foreground mt-2 mb-4">
            Explore Our Space
          </h2>
          <p className="text-muted-foreground text-lg">
            Take a virtual tour of our beautiful hotel and facilities.
          </p>
        </div>

        <div className="grid grid-cols-2 md:grid-cols-3 gap-4 max-w-5xl mx-auto">
          {galleryImages.map((image, index) => (
            <div
              key={index}
              className={`relative overflow-hidden rounded-xl cursor-pointer group ${
                index === 0 ? "col-span-2 row-span-2" : ""
              }`}
              onClick={() => setSelectedImage(image.src)}
            >
              <img
                src={image.src}
                alt={image.alt}
                className={`w-full object-cover transition-transform duration-500 group-hover:scale-110 ${
                  index === 0 ? "h-full min-h-[300px]" : "h-48 md:h-56"
                }`}
              />
              <div className="absolute inset-0 bg-gradient-to-t from-emerald-dark/70 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                <div className="absolute bottom-4 left-4">
                  <span className="text-xs text-gold font-medium uppercase tracking-wider">
                    {image.category}
                  </span>
                  <p className="text-primary-foreground font-semibold">{image.alt}</p>
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>

      {/* Lightbox */}
      {selectedImage && (
        <div
          className="fixed inset-0 z-50 bg-black/90 flex items-center justify-center p-4"
          onClick={() => setSelectedImage(null)}
        >
          <button
            className="absolute top-4 right-4 text-white hover:text-gold transition-colors"
            onClick={() => setSelectedImage(null)}
          >
            <X className="w-8 h-8" />
          </button>
          <img
            src={selectedImage}
            alt="Gallery preview"
            className="max-w-full max-h-[90vh] object-contain rounded-lg"
            onClick={(e) => e.stopPropagation()}
          />
        </div>
      )}
    </section>
  );
};
