import { Link } from "react-router-dom";
import { Phone, MapPin, Mail } from "lucide-react";

const footerLinks = [
  { label: "Home", href: "/" },
  { label: "About", href: "/about" },
  { label: "Rooms", href: "/rooms" },
  { label: "Amenities", href: "/amenities" },
  { label: "Gallery", href: "/gallery" },
  { label: "Contact", href: "/contact" },
];

export const Footer = () => {
  const currentYear = new Date().getFullYear();

  return (
    <footer className="bg-emerald-dark text-primary-foreground">
      <div className="container mx-auto px-4 py-12">
        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
          {/* Brand */}
          <div className="lg:col-span-2">
            <Link to="/" className="mb-4 inline-block">
              <span className="font-serif text-2xl font-bold">Graziella</span>
              <span className="block text-gold text-sm tracking-widest uppercase">
                Hotels & Suites
              </span>
            </Link>
            <p className="text-primary-foreground/70 leading-relaxed mb-4 max-w-md">
              Experience the perfect blend of comfort, elegance, and affordability at Graziella Hotels & Suites. Your home away from home in Imo State, Nigeria.
            </p>
            <div className="flex items-center gap-2 text-gold">
              <span className="text-2xl font-bold">₦12,000</span>
              <span className="text-primary-foreground/70">/night starting price</span>
            </div>
          </div>

          {/* Quick Links */}
          <div>
            <h4 className="font-semibold text-lg mb-4">Quick Links</h4>
            <nav className="space-y-2">
              {footerLinks.map((link) => (
                <Link
                  key={link.href}
                  to={link.href}
                  className="block text-primary-foreground/70 hover:text-gold transition-colors"
                >
                  {link.label}
                </Link>
              ))}
            </nav>
          </div>

          {/* Contact Info */}
          <div>
            <h4 className="font-semibold text-lg mb-4">Contact Info</h4>
            <div className="space-y-4">
              <a
                href="tel:07045064559"
                className="flex items-center gap-3 text-primary-foreground/70 hover:text-gold transition-colors"
              >
                <Phone className="w-5 h-5" />
                <span>0704 506 4559</span>
              </a>
              <div className="flex items-start gap-3 text-primary-foreground/70">
                <MapPin className="w-5 h-5 flex-shrink-0 mt-0.5" />
                <span>
                  KLM 7, Owerri – Onitsha Road,<br />
                  Orogwe, Ogbaku, Imo State
                </span>
              </div>
              <a
                href="mailto:info@graziellahotels.com"
                className="flex items-center gap-3 text-primary-foreground/70 hover:text-gold transition-colors"
              >
                <Mail className="w-5 h-5" />
                <span>info@graziellahotels.com</span>
              </a>
            </div>
          </div>
        </div>

        {/* Bottom Bar */}
        <div className="border-t border-primary-foreground/10 mt-8 pt-8">
          <div className="flex flex-col md:flex-row items-center justify-between gap-4">
            <p className="text-primary-foreground/50 text-sm text-center md:text-left">
              © {currentYear} Graziella Hotels & Suites. All rights reserved.
            </p>
            <div className="flex items-center gap-4 text-sm text-primary-foreground/50">
              <span>⭐ 3-Star Hotel</span>
              <span>•</span>
              <span>Ogbaku, Imo State</span>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
};
