import { 
  Wifi, 
  Car, 
  Utensils, 
  Shield, 
  Clock, 
  Zap, 
  Sparkles, 
  ConciergeBell,
  AirVent,
  Tv
} from "lucide-react";

const amenities = [
  {
    icon: Wifi,
    title: "Free WiFi",
    description: "Stay connected with complimentary high-speed internet throughout the hotel.",
  },
  {
    icon: Car,
    title: "Secure Parking",
    description: "Spacious and secure parking available for all guests at no extra charge.",
  },
  {
    icon: Utensils,
    title: "Restaurant",
    description: "Enjoy delicious local and continental dishes at our in-house restaurant.",
  },
  {
    icon: Shield,
    title: "24/7 Security",
    description: "Round-the-clock security personnel and CCTV surveillance for your safety.",
  },
  {
    icon: Clock,
    title: "24-Hour Front Desk",
    description: "Our friendly staff is available around the clock to assist you.",
  },
  {
    icon: Zap,
    title: "Constant Power",
    description: "Uninterrupted power supply with backup generators always on standby.",
  },
  {
    icon: Sparkles,
    title: "Daily Housekeeping",
    description: "Clean and fresh rooms maintained daily by our housekeeping team.",
  },
  {
    icon: ConciergeBell,
    title: "Room Service",
    description: "Enjoy meals and refreshments delivered right to your room.",
  },
  {
    icon: AirVent,
    title: "Air Conditioning",
    description: "Climate-controlled rooms for your comfort in any weather.",
  },
  {
    icon: Tv,
    title: "Cable TV",
    description: "Flat-screen TVs with cable channels in all rooms.",
  },
];

export const AmenitiesSection = () => {
  return (
    <section id="amenities" className="py-20 bg-primary">
      <div className="container mx-auto px-4">
        <div className="text-center max-w-2xl mx-auto mb-12">
          <span className="text-gold font-medium tracking-widest uppercase text-sm">
            Amenities
          </span>
          <h2 className="font-serif text-3xl md:text-4xl lg:text-5xl font-bold text-primary-foreground mt-2 mb-4">
            Hotel Facilities
          </h2>
          <p className="text-primary-foreground/80 text-lg">
            Everything you need for a comfortable and enjoyable stay.
          </p>
        </div>

        <div className="grid sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-5 gap-6 max-w-6xl mx-auto">
          {amenities.map((amenity, index) => (
            <div
              key={amenity.title}
              className="bg-primary-foreground/10 backdrop-blur-sm rounded-xl p-6 text-center hover:bg-primary-foreground/20 transition-all duration-300 group"
              style={{ animationDelay: `${index * 50}ms` }}
            >
              <div className="w-14 h-14 mx-auto mb-4 bg-gold/20 rounded-full flex items-center justify-center group-hover:scale-110 transition-transform">
                <amenity.icon className="w-7 h-7 text-gold" />
              </div>
              <h3 className="font-semibold text-primary-foreground mb-2">
                {amenity.title}
              </h3>
              <p className="text-primary-foreground/70 text-sm leading-relaxed">
                {amenity.description}
              </p>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};
