import { Clock, Heart, Shield, Users } from "lucide-react";

export const AboutSection = () => {
  return (
    <section id="about" className="py-20 bg-card">
      <div className="container mx-auto px-4">
        <div className="max-w-6xl mx-auto">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            {/* Text Content */}
            <div className="animate-slide-up">
              <span className="text-gold font-medium tracking-widest uppercase text-sm">
                About Us
              </span>
              <h2 className="font-serif text-3xl md:text-4xl lg:text-5xl font-bold text-foreground mt-2 mb-6">
                Your Comfort is Our Priority
              </h2>
              <p className="text-muted-foreground text-lg leading-relaxed mb-6">
                Welcome to Graziella Hotels & Suites, a distinguished 3-star hotel located along the vibrant Owerri – Onitsha Road in Ogbaku, Imo State. We pride ourselves on delivering warm Nigerian hospitality combined with modern comfort.
              </p>
              <p className="text-muted-foreground text-lg leading-relaxed mb-8">
                Whether you're a business traveler seeking convenience, a family on vacation, or a guest looking for a peaceful retreat, Graziella offers the perfect blend of affordability and elegance. Our dedicated staff ensures every moment of your stay is memorable.
              </p>

              {/* Info Cards */}
              <div className="grid sm:grid-cols-2 gap-4">
                <div className="flex items-start gap-4 p-4 bg-secondary rounded-xl">
                  <div className="w-12 h-12 bg-primary/10 rounded-full flex items-center justify-center flex-shrink-0">
                    <Clock className="w-6 h-6 text-primary" />
                  </div>
                  <div>
                    <h4 className="font-semibold text-foreground">Check-out Time</h4>
                    <p className="text-muted-foreground text-sm">12:00 Noon daily</p>
                  </div>
                </div>
                <div className="flex items-start gap-4 p-4 bg-secondary rounded-xl">
                  <div className="w-12 h-12 bg-primary/10 rounded-full flex items-center justify-center flex-shrink-0">
                    <Users className="w-6 h-6 text-primary" />
                  </div>
                  <div>
                    <h4 className="font-semibold text-foreground">24/7 Service</h4>
                    <p className="text-muted-foreground text-sm">Always at your service</p>
                  </div>
                </div>
              </div>
            </div>

            {/* Values Grid */}
            <div className="grid grid-cols-2 gap-4">
              <div className="bg-primary p-6 rounded-2xl text-primary-foreground">
                <Heart className="w-10 h-10 mb-4 text-gold" />
                <h3 className="font-serif text-xl font-semibold mb-2">Warm Hospitality</h3>
                <p className="text-primary-foreground/80 text-sm">
                  Experience genuine Nigerian warmth and care from our dedicated team.
                </p>
              </div>
              <div className="bg-secondary p-6 rounded-2xl mt-8">
                <Shield className="w-10 h-10 mb-4 text-primary" />
                <h3 className="font-serif text-xl font-semibold text-foreground mb-2">Safe & Secure</h3>
                <p className="text-muted-foreground text-sm">
                  24-hour security and secure parking for your peace of mind.
                </p>
              </div>
              <div className="bg-gold/10 p-6 rounded-2xl border border-gold/20">
                <div className="w-10 h-10 mb-4 font-serif text-3xl font-bold text-gold">3★</div>
                <h3 className="font-serif text-xl font-semibold text-foreground mb-2">Quality Standard</h3>
                <p className="text-muted-foreground text-sm">
                  Certified 3-star comfort at affordable prices.
                </p>
              </div>
              <div className="bg-cream-dark p-6 rounded-2xl mt-8">
                <div className="w-10 h-10 mb-4 font-serif text-2xl font-bold text-primary">₦</div>
                <h3 className="font-serif text-xl font-semibold text-foreground mb-2">Great Value</h3>
                <p className="text-muted-foreground text-sm">
                  Premium experience without the premium price tag.
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};
